from travel.avia.country_restrictions.lib.geo_format_manager import GeoFormatManager
from travel.avia.country_restrictions.lib.types.metric_type import APPROVED_VACCINES, IS_SPUTNIK_APPROVED, \
    VACCINE_REQUIRED
from travel.avia.country_restrictions.lib.types import CountryInfo


def processor(point_key: str, data: CountryInfo, geo_format_manager: GeoFormatManager) -> CountryInfo:
    vaccine_required = data.get(VACCINE_REQUIRED.name, None)
    if vaccine_required is None or vaccine_required.value is True:
        return data

    data.pop(IS_SPUTNIK_APPROVED.name)
    data.pop(APPROVED_VACCINES.name)

    return data
