from travel.avia.country_restrictions.lib.geo_format_manager import GeoFormatManager
from travel.avia.country_restrictions.lib.types.metric_type import VISA_ISSUANCE, VISA_REQUIRED
from travel.avia.country_restrictions.lib.types import CountryInfo


def processor(point_key: str, data: CountryInfo, geo_format_manager: GeoFormatManager) -> CountryInfo:
    visa_required = data.get(VISA_REQUIRED.name, None)
    visa_issuance = data.get(VISA_ISSUANCE.name, None)

    if visa_required is None or visa_issuance is None:
        return data

    if visa_required.value is True and visa_issuance.value is False:
        VISA_REQUIRED.modify_for_visa_issuance_suspension_info(visa_required)
        visa_required.union_metadata_from_another_metric(visa_issuance)

    del data[VISA_ISSUANCE.name]
    return data
