from travel.library.python.dicts.base_repository import BaseRepository
from travel.proto.dicts.rasp.country_pb2 import TCountry
from travel.proto.dicts.rasp.settlement_pb2 import TSettlement
from travel.proto.dicts.rasp.region_pb2 import TRegion


class BaseGeoIdRepository(BaseRepository):
    _default_index_field = 'GeoId'


class GeoIdSettlementRepository(BaseGeoIdRepository):
    _PB = TSettlement


class GeoIdRegionRepository(BaseGeoIdRepository):
    _PB = TRegion


class GeoIdCountryRepository(BaseGeoIdRepository):
    _PB = TCountry
