from travel.avia.country_restrictions.lib.geo_format_manager import GeoFormatManager
from travel.avia.country_restrictions.lib.utils.multi_cluster_yt_client import MultiClusterYtClient


def kwargs_prepare(**kwargs) -> dict:
    sandbox_token = kwargs.get('sandbox_token', None)
    if sandbox_token is not None:
        kwargs['geo_format_manager'] = GeoFormatManager(sandbox_token)
        del kwargs['sandbox_token']

    yt_proxies = kwargs.get('yt_proxies')
    yt_token = kwargs.get('yt_token')
    if yt_proxies is not None or yt_token is not None:
        kwargs['yt_client'] = MultiClusterYtClient(proxies=yt_proxies, token=yt_token)
        del kwargs['yt_proxies']
        del kwargs['yt_token']

    return kwargs
