from abc import ABC, abstractmethod

from travel.avia.country_restrictions.lib.solomon_pusher import SolomonPusher
from travel.avia.country_restrictions.lib.types import Environment


class AbcParser(ABC):
    PARSER_NAME = 'abc'

    def __init__(
        self,
        environment: Environment,
        version: int,
        solomon_token: str,
        geo_format_manager,
        **kwargs,
    ):
        self.environment = environment
        self.version = version
        self.solomon_pusher = SolomonPusher(environment, solomon_token, self.PARSER_NAME)
        self.geo_format_manager = geo_format_manager

    @abstractmethod
    def run(self):
        pass
