from travel.avia.country_restrictions.lib.parsers.to_yt_table_parser import ToYtTableParser


class PipelineParser(ToYtTableParser):
    """
    Pipeline for parsers
    Consistently apply run() for all parsers in self.PARSERS
    """

    PARSERS = []

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.parsers = [parser_class(**kwargs) for parser_class in self.PARSERS]

    def get_data(self, old_data):
        raise Exception('Should not be used in PipelineParser')

    def run(self):
        for parser in self.parsers:
            parser.run()
