from typing import Dict, List

from travel.avia.country_restrictions.lib.geo_format_manager import GeoFormatManager
from travel.avia.country_restrictions.lib.table_format.base_format import BaseFormat


class MetricsAsColumnsFormat(BaseFormat):
    def dict_data_to_yt_format(self, data, geo_format_manager: GeoFormatManager):
        rows = []
        for key, values in data.items():
            geo_id = geo_format_manager.get_geo_id_by_point_key(key)
            row_value = {
                MetricsAsColumnsFormat.YT_POINT_KEY_COLUMN_NAME: key,
                MetricsAsColumnsFormat.YT_GEO_ID_COLUMN_NAME: geo_id,
            }
            for metric_name, metric_value in values.items():
                row_value[metric_name] = metric_value
            rows.append(row_value)
        return rows

    def get_yt_schema(self, metric_types) -> List[Dict[str, str]]:
        result = [*self.indexes_column_descriptions]
        for metric_type in metric_types:
            result.append(metric_type.yt_format)
        return result
