from abc import abstractmethod
from typing import Dict, List

from travel.avia.country_restrictions.lib.geo_format_manager import GeoFormatManager
from travel.avia.country_restrictions.lib.table_format.base_format import BaseFormat
from travel.avia.country_restrictions.lib.utils.multi_cluster_yt_client import get_yt_column_description


class OneColumnMetricsBaseFormat(BaseFormat):
    YT_METRICS_AS_LIST_COLUMN_NAME: str = 'value'
    YT_METRICS_AS_LIST_COLUMN_TYPE = None

    @abstractmethod
    def process_geo_data(self, geo_data):
        pass

    def dict_data_to_yt_format(self, data, geo_format_manager: GeoFormatManager):
        rows = []
        for key, values in data.items():
            geo_id = geo_format_manager.get_geo_id_by_point_key(key)
            if geo_id is None:
                continue
            row_value = {
                OneColumnMetricsBaseFormat.YT_POINT_KEY_COLUMN_NAME: key,
                OneColumnMetricsBaseFormat.YT_GEO_ID_COLUMN_NAME: geo_id,
                OneColumnMetricsBaseFormat.YT_METRICS_AS_LIST_COLUMN_NAME: self.process_geo_data(values),
            }
            rows.append(row_value)
        return rows

    def get_yt_schema(self, metric_types) -> List[Dict[str, str]]:
        return [
            *self.indexes_column_descriptions,
            get_yt_column_description(self.YT_METRICS_AS_LIST_COLUMN_NAME, self.YT_METRICS_AS_LIST_COLUMN_TYPE),
        ]
