from dataclasses import dataclass
from enum import Enum
from typing import Dict, List, Optional

from travel.avia.country_restrictions.lib.types.metric import Metric


CountryInfo = Dict[str, Optional[Metric]]


class OutputFormat(Enum):
    MetricsAsList = 0
    MetricsAsJson = 1
    MetricsAsColumns = 2


InformationTable = Dict[str, CountryInfo]


@dataclass
class SourcePriorityInfo:
    source: str
    geo: Optional[List[str]] = None
    metrics: Optional[List[str]] = None


class Environment(Enum):
    UNSTABLE = 'unstable'
    TESTING = 'testing'
    PRODUCTION = 'production'

    @classmethod
    def from_str(cls, env: str):
        for elem in cls:
            if elem.value == env:
                return elem

        raise Exception(f'No such environment with name {env}')


class PointType(Enum):
    SETTLEMENT = 'c'
    REGION = 'r'
    COUNTRY = 'l'

    @classmethod
    def from_str(cls, key: str):
        for elem in cls:
            if elem.value == key:
                return elem

        raise Exception(f'No such PointType with name {key}')
