from enum import Enum

from travel.avia.country_restrictions.lib.types.metric_type.date_metric_type import DateMetricType
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import FlagMetricExtension, \
    FlagMetricExtensionType
from travel.avia.country_restrictions.lib.types.metric_type.visa_metric_type import VisaMetricType
from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.types.metric_type.enum_metric_type import EnumMetricType, MetricEnumElement
from travel.avia.country_restrictions.lib.types.metric_type.bank_card_payments_metric_type import (
    BankCardPaymentsMetricType
)
from travel.avia.country_restrictions.lib.types.metric_type.approved_vaccines_metric_type import (
    ApprovedVaccinesMetricType,
)
from travel.avia.country_restrictions.lib.types.metric_type.bool_metric_type import BoolMetricType
from travel.avia.country_restrictions.lib.types.metric_type.is_sputnik_approved_metric_type import (
    IsSputnikApprovedMetricType,
)
from travel.avia.country_restrictions.lib.types.metric_type.mobile_app_required_metric_type import (
    MobileAppRequiredMetricType,
)
from travel.avia.country_restrictions.lib.types.metric_type.pcr_expiration_period_in_hours_or_required_metric_type import (
    PcrExpirationPeriodInHoursOrRequiredMetricType,
)
from travel.avia.country_restrictions.lib.types.metric_type.quarantine_required_metric_type import (
    QuarantineRequiredMetricType,
)
from travel.avia.country_restrictions.lib.types.metric_type.url_list_metric_type import UrlListMetricType


# Авиасообщение
FLIGHTS_AVAILABILITY = BoolMetricType(
    name='flightsAvailability',
    title=new_rich_text('Авиасообщение'),
    icon24='Plane',
    short_if_no_advanced_info=True,
    true_text='Есть прямые рейсы',
    false_text='Прямых рейсов нет',
)

# Туризм
TOURISM_AVAILABILITY = BoolMetricType(
    name='tourismAvailability',
    title=new_rich_text('Туризм'),
    icon24='Tours',
    short_if_no_advanced_info=True,
    true_text='Туризм разрешён',
    false_text='Туризм временно невозможен',
)

QUARANTINE_REQUIRED = QuarantineRequiredMetricType(
    name='quarantineRequired',
    title=new_rich_text('Карантин'),
    icon24='CovidShild',
    short_if_no_advanced_info=False,
    none_text_for_extended_metric='Нет информации о необходимости карантина',
    true_text='Карантин по прилёту',
    false_text='Нет карантина',
    unit_text_prefix='Карантин',
    singular_unit='день',
    few_units='дня',
    many_units='дней',
    zero_int_to_false=True,
    exclusion_for_vaccinated_prefix='Для вакцинированных',
    exclusion_for_recovered_prefix='Для переболевших',
    exclusion_for_having_pcr_prefix='При наличии ПЦР',
    required_quarantine_before_pcr_results_text='Необходим карантин/самоизоляция до получения результатов ПЦР',
)


class VisaRequiredExtensions(Enum):
    VISA_ON_ARRIVAL = FlagMetricExtension(
        text=new_rich_text('Возможно оформление визы по прибытию'),
        extension_type=FlagMetricExtensionType.ADDITION,
    )
    ELECTRON_VISA = FlagMetricExtension(
        text=new_rich_text('Возможно оформление электронной визы'),
        extension_type=FlagMetricExtensionType.ADDITION,
    )
    EASY_VISA = FlagMetricExtension(
        text=new_rich_text('Упрощенный визовый режим'),
        extension_type=FlagMetricExtensionType.ADDITION,
    )
    VACCINATION_REQUIRED = FlagMetricExtension(
        text=new_rich_text('Необходимо наличие вакцинации'),
        extension_type=FlagMetricExtensionType.ADDITION,
    )


VISA_REQUIRED = VisaMetricType(
    name='visaRequired',
    title=new_rich_text('Виза'),
    icon24='Globe',
    short_if_no_advanced_info=True,
    available_flag_extensions=VisaRequiredExtensions,
    none_text_for_extended_metric='Нет информации о необходимости визы',
    true_text='Нужна виза',
    false_text='Виза не нужна',
    visa_required_with_issuance_suspension_text='Для въезда нужна виза, но на данный момент выдача виз гражданам '
                                                'России приостановлена',
    visa_cost_prefix='Стоимость визы:',

    no_visa_period_prefix='Безвизовый период - ',
    singular_unit='день',
    few_units='дня',
    many_units='дней',
)

COVID_INSURANCE_REQUIRED = BoolMetricType(
    name='covidInsuranceRequired',
    title=new_rich_text('Страхование COVID-19'),
    icon24='CovidShild',
    short_if_no_advanced_info=False,
    true_text='Необходима страховка Covid-19',
    false_text='Страховка от Covid-19 не обязательна',
)

MOBILE_APP_REQUIRED = MobileAppRequiredMetricType(
    name='mobileAppRequired',
    title=new_rich_text('Мобильное приложение'),
    icon24='InternetAndTelephony',
    short_if_no_advanced_info=False,
    true_text='Необходимо установить мобильное приложение',
    false_text='Установка мобильного приложения не обязательна',
    required_install_mobile_app_prefix='Необходимо установить мобильное приложение',
    links_singular_prefix='по ссылке',
    links_plural_prefix='по ссылкам',
)


class PcrExpirationPeriodInHoursOrRequiredExtensions(Enum):
    CHILDREN_FREE = FlagMetricExtension(
        text=new_rich_text('Не нужен для детей'),
        extension_type=FlagMetricExtensionType.EXCLUSION,
    )
    ANTIGEN_TEST = FlagMetricExtension(
        text=new_rich_text('Необходим антиген тест по прибытии'),
        extension_type=FlagMetricExtensionType.ADDITION,
    )


PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED = PcrExpirationPeriodInHoursOrRequiredMetricType(
    name='pcrExpirationPeriodInHoursOrRequired',
    title=new_rich_text('ПЦР-тест'),
    icon24='Shild',
    short_if_no_advanced_info=False,
    available_flag_extensions=PcrExpirationPeriodInHoursOrRequiredExtensions,
    none_text_for_extended_metric='Нет информации о необходимости ПЦР',
    true_text='Требуется ПЦР',
    false_text='ПЦР не обязателен',
    unit_text_prefix='Требуется ПЦР, сделанный не более',
    singular_unit='часа',
    few_units='часов',
    many_units='часов',
    unit_text_suffix='назад',
    zero_int_to_false=True,
    children_less_year_free_text='Не нужен для детей, чей возраст менее одного года',
    children_free_before_age_prefix='Не нужен для детей до',
)

APPROVED_VACCINES = ApprovedVaccinesMetricType(
    name='approvedVaccines',
    title=new_rich_text('Разрешённые вакцины'),
    icon24='CovidShild',
    short_if_no_advanced_info=False,
    singular_prefix_text='Разрешенная для въезда вакцина:',
    plural_prefix_text='Разрешенные для въезда вакцины:',
    trim_empty_elements=True,
    none_if_empty=True,
    empty_list_text='',
    quarantine_vaccines_prefix='Карантин нужен для привитых',
    all_vaccines_quarantine_text='При вакцинации необходим карантин',
)

VACCINE_REQUIRED = BoolMetricType(
    name='vaccineRequired',
    title=new_rich_text('Необходимость вакцины'),
    icon24='CovidShild',
    short_if_no_advanced_info=True,
    true_text='Вакцина необходима для посещения страны',
    false_text='Нет необходимости вакцинации для посещения страны',
)

IS_SPUTNIK_APPROVED = IsSputnikApprovedMetricType(
    name='isSputnikApproved',
    title=new_rich_text('Спутник-V'),
    icon24='CovidShild',
    short_if_no_advanced_info=True,
    true_text='Можно со Спутником-V',
    false_text='Спутник-V не входит в список вакцин, принимаемых для въезда',
    required_quarantine_exclusion='При вакцинации необходим карантин',
)

FORMS_TO_FILL = UrlListMetricType(
    name='formsToFill',
    title=new_rich_text('Регистрация прибывающих'),
    icon24='Questionnaire',
    short_if_no_advanced_info=False,
    singular_prefix_text='Доступна форма для предварительного заполнения:',
    plural_prefix_text='Доступны формы для предварительного заполнения:',
    trim_empty_elements=True,
    none_if_empty=True,
    empty_list_text='',
    urls_to_numbers=True,
    singular_link_text='по ссылке',
)

BANK_CARD_PAYMENTS = BankCardPaymentsMetricType(
    name='bankCardPayments',
    title=new_rich_text('Банковские карты'),
    icon24='Card',
    short_if_no_advanced_info=False,
    singular_work_prefix='Принимается',
    plural_work_prefix='Принимаются',
    russian_visa_mastercard_text='выпущенные в России Visa и MasterCard',
    mir_text='Мир',
    union_pay_text='UnionPay',
    article_info_text='Подробнее об использовании российских карт за границей',
    article_info_link='https://travel.yandex.ru/journal/flight-restrictions#bankovskie_karty',
)


# ENTRANCE_FOR_RUSSIANS

class EntranceForRussiansEnum(Enum):
    FREE_ENTRANCE = MetricEnumElement(value='freeEntrance', text=new_rich_text('Нет ограничений для въезда'))
    HAS_RESTRICTIONS = MetricEnumElement(
        value='hasRestrictions',
        text=new_rich_text('Есть ограничения для въезда граждан России'),
    )
    NO_ENTRANCE = MetricEnumElement(value='noEntrance', text=new_rich_text('Въезд для граждан России запрещён'))


class EntranceForRussiansFlagExtensions(Enum):
    CLOSED_SKY = FlagMetricExtension(
        text=new_rich_text('Воздушное пространство закрыто для авиакомпаний РФ'),
        extension_type=FlagMetricExtensionType.ADDITION,
    )


ENTRANCE_FOR_RUSSIANS = EnumMetricType(
    name='entranceForRussians',
    title=new_rich_text('Ограничения'),
    icon24='CheckCircle',
    short_if_no_advanced_info=False,
    values=EntranceForRussiansEnum,
    available_flag_extensions=EntranceForRussiansFlagExtensions,
)


# FLIGHTS_AVAILABILITY_V2

class FlightAvailabilityV2Enum(Enum):
    DIRECT_FLIGHTS = MetricEnumElement(value='directFlights', text=new_rich_text('Есть прямые рейсы'))
    TRANSFER_FLIGHTS = MetricEnumElement(value='transferFlights', text=new_rich_text('Можно долететь с пересадками'))
    NO_FLIGHTS = MetricEnumElement(value='noFLights', text=new_rich_text('Авиасообщение приостановлено'))


FLIGHTS_AVAILABILITY_V2 = EnumMetricType(
    name='flightsAvailabilityV2',
    title=new_rich_text('Авиасообщение'),
    icon24='Plane',
    short_if_no_advanced_info=True,
    values=FlightAvailabilityV2Enum,
)


VISA_ISSUANCE = BoolMetricType(
    name='visaIssuanceMetricType',
    title=new_rich_text('Выдача виз'),
    icon24='Globe',
    short_if_no_advanced_info=True,
    true_text='Визы выдаются в обычном режиме',
    false_text='Выдача виз приостановлена',
)


TOURISM_AVAILABLE_FROM_METRIC_TYPE = DateMetricType(
    name='tourismAvailableFromMetricType',
    title=new_rich_text('Открытие страны'),
    icon24='Tours',
    short_if_no_advanced_info=True,
    prefix='Закрыто для путешествий до',
)

# Служебная метрика
AIRPORT_AVAILABILITY_IN_COUNTRY = BoolMetricType(
    name='airportAvailableInCountry',
    title=new_rich_text('Наличие аэропорта в стране'),
    icon24='Globe',
    short_if_no_advanced_info=True,
    true_text='',
    false_text='',
)

ALL_METRICS = [
    AIRPORT_AVAILABILITY_IN_COUNTRY,
    APPROVED_VACCINES,
    BANK_CARD_PAYMENTS,
    COVID_INSURANCE_REQUIRED,
    ENTRANCE_FOR_RUSSIANS,
    FLIGHTS_AVAILABILITY,
    FLIGHTS_AVAILABILITY_V2,
    FORMS_TO_FILL,
    IS_SPUTNIK_APPROVED,
    MOBILE_APP_REQUIRED,
    PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED,
    QUARANTINE_REQUIRED,
    TOURISM_AVAILABLE_FROM_METRIC_TYPE,
    TOURISM_AVAILABILITY,
    VACCINE_REQUIRED,
    VISA_ISSUANCE,
    VISA_REQUIRED,
]


# Update https://wiki.yandex-team.ru/avia/dev/services-table/country-restrictions/#informacijanarazvernutombannere
# if you want to update this
METRICS_FOR_EXTENDED_BANNER = [
    FLIGHTS_AVAILABILITY_V2,
    PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED,
    IS_SPUTNIK_APPROVED,
    FORMS_TO_FILL,
    QUARANTINE_REQUIRED,
    VISA_REQUIRED,
    BANK_CARD_PAYMENTS,
]
