from typing import List

from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.list_metric_type import ListMetricType


class ApprovedVaccinesMetricType(ListMetricType):
    quarantine_vaccines_prefix: str
    all_vaccines_quarantine_text: str

    def set_quarantine_vaccines_text(self, metric: Metric, vaccines: List[str]):
        if set(vaccines) == set(metric.value):
            metric.additions.append(new_rich_text(self.all_vaccines_quarantine_text))
        else:
            vaccines_str = ', '.join(vaccines)
            text = f'{self.quarantine_vaccines_prefix} {vaccines_str}'
            metric.additions.append(new_rich_text(text))
