from typing import Any, Optional

from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import MetricType


TRUE_TEXTS = ['yes', 'да']
FALSE_TEXTS = ['no', 'нет']


class BoolMetricType(MetricType):
    true_text: str
    false_text: str

    def generate_metric(self, value: Any, additions=None, exclusions=None, updated_user=None) -> Optional[Metric]:
        if additions is None:
            additions = []
        if exclusions is None:
            exclusions = []

        metric_value: Any
        metric_text: str

        if value is None:
            return None
        elif isinstance(value, str):
            if value in TRUE_TEXTS:
                metric_value = True
                metric_text = self.true_text
            elif value in FALSE_TEXTS:
                metric_value = False
                metric_text = self.false_text
            else:
                return None
        elif isinstance(value, bool):
            if value:
                metric_value = True
                metric_text = self.true_text
            else:
                metric_value = False
                metric_text = self.false_text
        else:
            return None

        return Metric(
            value=metric_value,
            text=new_rich_text(metric_text),
            additions=additions,
            exclusions=exclusions,
            updated_user=updated_user,
        )

    @property
    def value_type(self) -> type:
        return bool
