from datetime import datetime, date
from typing import Optional

from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import MetricType
from travel.avia.library.python.translations.date import to_ru_str as date_to_ru_str, MONTHS_GENITIVE_CASE


class DateMetricType(MetricType):
    prefix: str

    def generate_metric(
        self,
        value: Optional[datetime.date],
        additions=None,
        exclusions=None,
        updated_user=None,
    ) -> Optional[Metric]:
        if additions is None:
            additions = []
        if exclusions is None:
            exclusions = []

        if not isinstance(value, date):
            return None

        return Metric(
            value=value.strftime('%Y-%m-%d'),
            text=new_rich_text(f'{self.prefix} {date_to_ru_str(value, MONTHS_GENITIVE_CASE, True, False)}'),
            additions=additions,
            exclusions=exclusions,
            updated_user=updated_user,
        )

    @property
    def value_type(self) -> type:
        return str
