from dataclasses import dataclass
from typing import Any, Optional

from travel.avia.country_restrictions.lib.types.rich_string import RichString
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import MetricType


@dataclass
class MetricEnumElement:
    value: str
    text: RichString


class EnumMetricType(MetricType):
    values: Any

    def generate_metric(
        self,
        value: Optional[MetricEnumElement],
        additions=None,
        exclusions=None,
        updated_user=None,
    ) -> Optional[Metric]:
        if additions is None:
            additions = []
        if exclusions is None:
            exclusions = []

        for elem in list(self.values):
            if value is elem:
                return Metric(
                    value=value.value.value,
                    text=value.value.text,
                    additions=additions,
                    exclusions=exclusions,
                    updated_user=updated_user,
                )

        return None

    @property
    def value_type(self) -> type:
        return str
