from typing import Optional

from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import MetricType
from travel.avia.library.python.translations import number_with_measurement_unit


class IntMetricType(MetricType):
    singular_unit: str
    few_units: str
    many_units: str
    unit_text_prefix: str = ''
    unit_text_suffix: str = ''

    def generate_metric(
        self,
        value: Optional[int],
        additions=None,
        exclusions=None,
        updated_user=None,
    ) -> Optional[Metric]:
        if additions is None:
            additions = []
        if exclusions is None:
            exclusions = []

        if type(value) != int:
            return None

        pre_text = self.unit_text_prefix
        if pre_text != '':
            pre_text += ' '
        pre_text += number_with_measurement_unit.to_ru_str(value, self.singular_unit, self.few_units, self.many_units)
        if self.unit_text_suffix != '':
            pre_text += ' ' + self.unit_text_suffix

        return Metric(
            value=value,
            text=new_rich_text(pre_text),
            additions=additions,
            exclusions=exclusions,
            updated_user=updated_user,
        )

    @property
    def value_type(self) -> type:
        return int
