from typing import Optional, Union

from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.bool_metric_type import BoolMetricType
from travel.avia.country_restrictions.lib.types.metric_type.int_metric_type import IntMetricType


class IntOrBoolMetricType(IntMetricType, BoolMetricType):
    zero_int_to_false: bool

    def generate_metric(
        self,
        value: Union[int, bool, str, None],
        additions=None,
        exclusions=None,
        updated_user=None,
    ) -> Optional[Metric]:

        if value == 0 and self.zero_int_to_false:
            value = False

        int_metric = IntMetricType.generate_metric(self, value, additions, exclusions, updated_user)
        if int_metric is not None:
            return int_metric
        return BoolMetricType.generate_metric(self, value, additions, exclusions, updated_user)

    @property
    def value_type(self) -> type:
        return Union[bool, int]
