from typing import List

from travel.avia.country_restrictions.lib.types.metric_type.url_list_metric_type import UrlListMetricType
from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text, RichString
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.bool_metric_type import BoolMetricType


class MobileAppRequiredMetricType(BoolMetricType):
    required_install_mobile_app_prefix: str
    links_plural_prefix: str
    links_singular_prefix: str

    def set_mobile_app_details_data(
        self,
        metric: Metric,
        app_name: str = None,
        links: List[str] = None,
    ):
        result = RichString(data=[])

        if app_name is not None:
            result.append(' ' + app_name)

        links_addition = UrlListMetricType(
            name='',
            title=new_rich_text(''),
            icon24='',
            short_if_no_advanced_info=False,
            singular_prefix_text=self.links_singular_prefix,
            plural_prefix_text=self.links_plural_prefix,
            trim_empty_elements=True,
            none_if_empty=True,
            empty_list_text='',
            urls_to_numbers=False,
            singular_link_text='',
        ).generate_metric(links)

        if links_addition is None:
            if app_name is None:
                return
        else:
            result.extend(links_addition.text.data)

        metric.additions.append(result)
