from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.int_or_bool_metric_type import IntOrBoolMetricType
from travel.avia.library.python.translations import number_with_measurement_unit


class PcrExpirationPeriodInHoursOrRequiredMetricType(IntOrBoolMetricType):
    children_less_year_free_text: str
    children_free_before_age_prefix: str

    def set_children_pcr_free_before_age_text(self, metric: Metric, age: int):
        if age == 0:
            text = self.children_less_year_free_text
        else:
            text = (
                f"{self.children_free_before_age_prefix} "
                f"{number_with_measurement_unit.to_ru_str(age, 'года', 'лет', 'лет')}"
            )

        metric.exclusions.append(new_rich_text(text))
