from typing import Union

from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.int_or_bool_metric_type import IntOrBoolMetricType


class QuarantineRequiredMetricType(IntOrBoolMetricType):
    exclusion_for_vaccinated_prefix: str
    exclusion_for_recovered_prefix: str
    exclusion_for_having_pcr_prefix: str

    required_quarantine_before_pcr_results_text: str

    def set_group_exclusion(self, metric: Metric, prefix: str, value: Union[int, bool]):
        if value is None or value == metric.value:
            return

        exclusion_metric = self.generate_metric(value)
        if exclusion_metric is None:
            return

        result_text = new_rich_text(f'{prefix}: ')
        exclusion_text = exclusion_metric.text
        exclusion_text.lower()
        result_text.extend(exclusion_text)
        result_text.compress()
        metric.exclusions.append(result_text)

    def set_for_vaccinated_exclusion(self, metric: Metric, value: Union[int, bool]):
        self.set_group_exclusion(metric, self.exclusion_for_vaccinated_prefix, value)

    def set_for_recovered_exclusion(self, metric: Metric, value: Union[int, bool]):
        self.set_group_exclusion(metric, self.exclusion_for_recovered_prefix, value)

    def set_for_having_pcr_exclusion(self, metric: Metric, value: Union[int, bool]):
        self.set_group_exclusion(metric, self.exclusion_for_having_pcr_prefix, value)

    def set_required_quarantine_before_pcr_results_text_exclusion(self, metric: Metric):
        if metric.value is not False:
            return

        metric.exclusions.append(new_rich_text(self.required_quarantine_before_pcr_results_text))
