from travel.avia.country_restrictions.lib.types.metric_type.list_metric_type import ListMetricType
from travel.avia.country_restrictions.lib.types.rich_string import RichString, TextBlock, UrlBlock


class UrlListMetricType(ListMetricType):
    # if True, text for urls will be 1, 2, 3, ...
    urls_to_numbers: bool
    singular_link_text: str

    def element_to_rich_string(self, elem: str, elem_number: int, total_number: int) -> RichString:
        if self.urls_to_numbers:
            if total_number == 1:
                url_text = self.singular_link_text
            else:
                url_text = str(elem_number + 1)
        else:
            url_text = elem

        if elem_number != total_number - 1:
            return RichString(data=[UrlBlock.create(text=url_text, url=elem), TextBlock.create(text=', ')])
        else:
            return RichString(data=[UrlBlock.create(text=url_text, url=elem)])
