from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.metric_type.bool_metric_type import BoolMetricType
from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.library.python.translations import number_with_measurement_unit


class VisaMetricType(BoolMetricType):
    visa_required_with_issuance_suspension_text: str
    visa_cost_prefix: str

    no_visa_period_prefix: str
    singular_unit: str
    few_units: str
    many_units: str

    def modify_for_visa_issuance_suspension_info(self, metric):
        metric.text = new_rich_text(self.visa_required_with_issuance_suspension_text)

    def add_visa_cost_information(self, metric: Metric, value: int, currency_symbol: str):
        metric.additions.append(new_rich_text(f'{self.visa_cost_prefix} {value}{currency_symbol}'))

    def add_no_visa_period(self, metric: Metric, value: int):
        days = number_with_measurement_unit.to_ru_str(value, self.singular_unit, self.few_units, self.many_units)
        metric.exclusions.append(new_rich_text(f'{self.no_visa_period_prefix} {days}'))
