from typing import Any, Dict, List

from travel.avia.country_restrictions.lib.types import SourcePriorityInfo
from travel.avia.country_restrictions.parsers.assessors_visa import AssessorsVisaParser
from travel.avia.country_restrictions.parsers.assessors_main import AssessorsMainParser
from travel.avia.country_restrictions.parsers.inline_admin import InlineAdminParser
from travel.avia.country_restrictions.parsers.serp import SerpParser

PARSERS = [AssessorsVisaParser, AssessorsMainParser, InlineAdminParser, SerpParser]


PARSERS_PRIORITY: List[SourcePriorityInfo] = [
    SourcePriorityInfo(source=InlineAdminParser.SOURCE_ID),
    SourcePriorityInfo(source=AssessorsVisaParser.SOURCE_ID),
    SourcePriorityInfo(source=AssessorsMainParser.SOURCE_ID),
    SourcePriorityInfo(source=SerpParser.SOURCE_ID),
]


def get_parsers_class_by_id_dict() -> Dict[str, Any]:
    return {v.SOURCE_ID: v for v in PARSERS}


def get_parsers_tables_by_id_dict(**kwargs) -> Dict[str, str]:
    """
    :param kwargs: kwargs as for Parser init()
    :return: Dict[parser id : parser table]
    """
    result = {}
    for parser_class in PARSERS:
        result[parser_class.SOURCE_ID] = parser_class.get_updating_table_fullname_static(**kwargs)
    return result
