from typing import List

from travel.avia.country_restrictions.lib.table_format.base_format import BaseFormat
from travel.avia.country_restrictions.lib.table_format.metrics_as_columns_format import MetricsAsColumnsFormat
from travel.avia.country_restrictions.lib.parsers.assessors_base import AssessorsBaseParser
from travel.avia.country_restrictions.lib.types.metric_type import (
    APPROVED_VACCINES,
    BANK_CARD_PAYMENTS,
    COVID_INSURANCE_REQUIRED,
    ENTRANCE_FOR_RUSSIANS,
    FLIGHTS_AVAILABILITY_V2,
    FORMS_TO_FILL,
    IS_SPUTNIK_APPROVED,
    MOBILE_APP_REQUIRED,
    PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED,
    TOURISM_AVAILABILITY,
    TOURISM_AVAILABLE_FROM_METRIC_TYPE,
    QUARANTINE_REQUIRED,
    VACCINE_REQUIRED,
    VISA_ISSUANCE,
)
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import MetricType
from travel.avia.country_restrictions.parsers.assessors_main.subparsers import SUBPARSERS as SUBPARSERS_FUNCTIONS


class AssessorsMainParser(AssessorsBaseParser):
    COUNTRIES_INPUT_YT_TABLES_FOLDERS = [
        '//home/travel/ritapak/covid/data/detailed_actualization/countries',
    ]
    REGIONS_INPUT_YT_TABLES_FOLDERS = [
        '//home/travel/ritapak/covid/data/detailed_actualization/regions',
    ]
    SOURCE_ID = 'assessors-main'
    METRIC_TYPES: List[MetricType] = [
        APPROVED_VACCINES,
        BANK_CARD_PAYMENTS,
        COVID_INSURANCE_REQUIRED,
        ENTRANCE_FOR_RUSSIANS,
        FLIGHTS_AVAILABILITY_V2,
        FORMS_TO_FILL,
        IS_SPUTNIK_APPROVED,
        MOBILE_APP_REQUIRED,
        PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED,
        TOURISM_AVAILABILITY,
        TOURISM_AVAILABLE_FROM_METRIC_TYPE,
        QUARANTINE_REQUIRED,
        VACCINE_REQUIRED,
        VISA_ISSUANCE,

    ]

    UPDATING_TABLE_NAME = 'source-assessors-main-result'
    OUTPUT_TABLE_FORMATS: List[BaseFormat] = [
        MetricsAsColumnsFormat(output_table_short_name='source-assessors-main-result')
    ]

    PARSER_NAME = SOURCE_ID
    LOOK_ONLY_NEW_TABLES = False

    SUBPARSERS = SUBPARSERS_FUNCTIONS
