from travel.avia.country_restrictions.lib.types import Metric
from travel.avia.country_restrictions.lib.types.rich_string import new_rich_text
from travel.avia.country_restrictions.lib.utils.settings import USE_RAW_COMMENTS_FROM_ASSESSORS


def add_raw_assessors_additions(metric: Metric, raw_additions):
    if USE_RAW_COMMENTS_FROM_ASSESSORS is False:
        return

    if raw_additions is None or len(raw_additions) == 0:
        return

    for elem in raw_additions:
        metric.additions.append(new_rich_text(elem))
