from typing import Any, Dict

from travel.avia.country_restrictions.parsers.assessors_main.subparsers.helper import add_raw_assessors_additions
from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import BANK_CARD_PAYMENTS


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    card_payment = row.get('card_payment', None)

    if card_payment is None:
        return {}

    card_data = BANK_CARD_PAYMENTS.InternalData(
        russian_visa_mastercard=not card_payment.get('no_Visa_MasterCard', False),
        mir=not card_payment.get('no_MIR', False),
        union_pay=not card_payment.get('no_UnionPay', False),
    )

    metric = BANK_CARD_PAYMENTS.generate_metric(value=card_data)
    if metric is None:
        return {}

    BANK_CARD_PAYMENTS.set_article_info(metric)
    add_raw_assessors_additions(metric, row.get('card_payment_comment', []))

    return {
        BANK_CARD_PAYMENTS.name: metric,
    }
