from typing import Any, Dict

from travel.avia.country_restrictions.parsers.assessors_main.subparsers.helper import add_raw_assessors_additions
from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import ENTRANCE_FOR_RUSSIANS, \
    EntranceForRussiansEnum, EntranceForRussiansFlagExtensions


ENTRY_POSSIBILITY_DUE_TO_POLITICS_CONNECTION = {
    'yes': EntranceForRussiansEnum.FREE_ENTRANCE,
    'with_restrictions': EntranceForRussiansEnum.HAS_RESTRICTIONS,
    'no': EntranceForRussiansEnum.NO_ENTRANCE,
}


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    entry_possibility_due_to_politics = row.get('entry_possibility_due_to_politics', None)
    value = ENTRY_POSSIBILITY_DUE_TO_POLITICS_CONNECTION.get(entry_possibility_due_to_politics, None)
    if value is None:
        return {}

    metric = ENTRANCE_FOR_RUSSIANS.generate_metric(value)
    if metric is None:
        return {}

    restrictions_list = row.get('restrictions_list', {})
    if restrictions_list is None:
        restrictions_list = {}

    if restrictions_list.get('closed_airspace', False) is True:
        ENTRANCE_FOR_RUSSIANS.set_flag_extension(metric, EntranceForRussiansFlagExtensions.CLOSED_SKY)

    add_raw_assessors_additions(metric, row.get('restrictions_list_comment', []))

    return {
        ENTRANCE_FOR_RUSSIANS.name: metric,
    }
