from typing import Any, Dict

from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import FLIGHTS_AVAILABILITY_V2, FlightAvailabilityV2Enum


AVIA_CONNECTIONS = {
    'direct_flights': FlightAvailabilityV2Enum.DIRECT_FLIGHTS,
    'flight_with_transfers': FlightAvailabilityV2Enum.TRANSFER_FLIGHTS,
    'no_flights': FlightAvailabilityV2Enum.NO_FLIGHTS,
}


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    avia = row.get('avia', None)
    value = AVIA_CONNECTIONS.get(avia, None)
    if value is None:
        return {}

    return {
        FLIGHTS_AVAILABILITY_V2.name: FLIGHTS_AVAILABILITY_V2.generate_metric(value),
    }
