from typing import Any, Dict

from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import FORMS_TO_FILL


def parser(context: CountryInfo, row: Dict[str, Any]):
    forms = row.get('forms', None)
    if forms is None:
        return {}

    return {FORMS_TO_FILL.name: FORMS_TO_FILL.generate_metric(forms)}
