from typing import Any, Dict
from urllib.parse import urlparse

from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import MOBILE_APP_REQUIRED


def is_url(url):
    try:
        result = urlparse(url)
        return all([result.scheme, result.netloc])
    except ValueError:
        return False


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    mobile_app = row.get('mobile_app', None)
    if mobile_app is None:
        return {}

    mobile_app_data = context.get(MOBILE_APP_REQUIRED.name, MOBILE_APP_REQUIRED.generate_metric(True))

    mobile_app_info_tokens = mobile_app.split('\n')
    links = []
    for token in mobile_app_info_tokens:
        if is_url(token):
            links.append(token)

    MOBILE_APP_REQUIRED.set_mobile_app_details_data(metric=mobile_app_data, app_name=None, links=links)

    return {
        MOBILE_APP_REQUIRED.name: mobile_app_data,
    }
