from typing import Any, Dict

from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import QUARANTINE_REQUIRED

QUARANTINE_FOR_EVERYONE = 'Общий карантин для всех'
QUARANTINE_FOR_VACCINATED = 'Для вакцинированных'
QUARANTINE_FOR_RECOVERED = 'Для переболевших'
QUARANTINE_WITH_PCR = 'При наличии ПЦР'
QUARANTINE_BEFORE_PCR_RESULTS = 'Карантин/самоизоляция до результатов ПЦР'


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    has_quarantine = row.get('has_quarantine', None)
    quarantine = row.get('quarantine', None)
    quarantine_days = row.get('quarantine_days', None)

    quarantine_main_info_value = has_quarantine
    # Dict[category of people : value]
    quarantine_main_info_exclusions = {}

    quarantine_more_info_days = {}

    if quarantine is not None:
        for text, bool_value in quarantine.items():
            quarantine_more_info_days[text] = bool_value

    if quarantine_days is not None:
        for text, days_value in quarantine_days.items():
            quarantine_more_info_days[text] = days_value

    for text, info in quarantine_more_info_days.items():
        if text == QUARANTINE_FOR_EVERYONE:
            if isinstance(info, bool) and not isinstance(quarantine_main_info_value, int):
                quarantine_main_info_value = info
            elif isinstance(info, int):
                quarantine_main_info_value = info
        else:
            if (isinstance(info, bool) or isinstance(info, int)) and quarantine_main_info_value != info:
                quarantine_main_info_exclusions[text] = info

    metric = QUARANTINE_REQUIRED.generate_metric(quarantine_main_info_value)
    if metric is None:
        return {}

    for text, value in quarantine_main_info_exclusions.items():
        if text == QUARANTINE_FOR_VACCINATED:
            QUARANTINE_REQUIRED.set_for_vaccinated_exclusion(metric, value)
        elif text == QUARANTINE_FOR_RECOVERED:
            QUARANTINE_REQUIRED.set_for_recovered_exclusion(metric, value)
        elif text == QUARANTINE_WITH_PCR:
            QUARANTINE_REQUIRED.set_for_having_pcr_exclusion(metric, value)

    quarantine_before_pcr = quarantine_main_info_exclusions.get(QUARANTINE_BEFORE_PCR_RESULTS, None)
    if quarantine_before_pcr is True:
        QUARANTINE_REQUIRED.set_required_quarantine_before_pcr_results_text_exclusion(metric)

    return {
        QUARANTINE_REQUIRED.name: metric,
    }
