from datetime import datetime
from typing import Any, Dict

from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import TOURISM_AVAILABILITY, \
    TOURISM_AVAILABLE_FROM_METRIC_TYPE


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    tourism = row.get('tourism', None)
    if tourism == 'yes':
        tourism_flag = True
    elif tourism == 'no':
        tourism_flag = False
    else:
        return {}

    tourism_metric = TOURISM_AVAILABILITY.generate_metric(tourism_flag)

    opened_from_str = row.get('opening_date', None)
    if opened_from_str is None:
        return {TOURISM_AVAILABILITY.name: tourism_metric}

    opened_from_value = datetime.strptime(opened_from_str, "%Y-%m-%dT%H:%M:%S%z")
    opened_from_metric = TOURISM_AVAILABLE_FROM_METRIC_TYPE.generate_metric(opened_from_value.date())

    return {
        TOURISM_AVAILABILITY.name: tourism_metric,
        TOURISM_AVAILABLE_FROM_METRIC_TYPE.name: opened_from_metric,
    }
