from typing import Any, Dict

from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import VISA_ISSUANCE


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    restrictions_list = row.get('restrictions_list', {})
    if restrictions_list is None:
        restrictions_list = {}

    if not isinstance(restrictions_list, dict):
        restrictions_list = {}

    metric = VISA_ISSUANCE.generate_metric(not restrictions_list.get('no_visa', False))
    return {
        VISA_ISSUANCE.name: metric,
    }
