from typing import List

from travel.avia.country_restrictions.lib.table_format.base_format import BaseFormat
from travel.avia.country_restrictions.lib.table_format.metrics_as_columns_format import MetricsAsColumnsFormat
from travel.avia.country_restrictions.lib.parsers.assessors_base import AssessorsBaseParser
from travel.avia.country_restrictions.lib.types.metric_type import (
    VISA_REQUIRED,
)
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import MetricType
from travel.avia.country_restrictions.parsers.assessors_visa.parse_visa import parser as visa_parser


class AssessorsVisaParser(AssessorsBaseParser):
    COUNTRIES_INPUT_YT_TABLES_FOLDERS = [
        '//home/travel/ritapak/covid/data/visa_requirements/result',
    ]
    SOURCE_ID = 'assessors-visa'
    METRIC_TYPES: List[MetricType] = [VISA_REQUIRED]

    UPDATING_TABLE_NAME = 'source-assessors-visa-result'
    OUTPUT_TABLE_FORMATS: List[BaseFormat] = [
        MetricsAsColumnsFormat(output_table_short_name='source-assessors-visa-result')
    ]

    PARSER_NAME = SOURCE_ID
    LOOK_ONLY_NEW_TABLES = False

    SUBPARSERS = [visa_parser]
