from typing import Any, Dict

from travel.avia.country_restrictions.lib.types import CountryInfo
from travel.avia.country_restrictions.lib.types.metric_type import VISA_REQUIRED, VisaRequiredExtensions


def parser(context: CountryInfo, row: Dict[str, Any]) -> CountryInfo:
    visa_data = row.get('visa', [])
    if visa_data is None or len(visa_data) == 0:
        return {}

    visa_required = True

    if 'no' in visa_data:
        visa_required = False

    visa_metric = VISA_REQUIRED.generate_metric(visa_required)

    visa_currency = row.get('currency', None)
    visa_cost = row.get('visa_cost', None)
    if visa_currency is not None and visa_cost is not None:
        VISA_REQUIRED.add_visa_cost_information(visa_metric, visa_cost, visa_currency)

    if row.get('WHO_vaccination_required', None) == 'yes':
        VISA_REQUIRED.set_flag_extension(visa_metric, VisaRequiredExtensions.VACCINATION_REQUIRED)

    if 'e_visa' in visa_data:
        VISA_REQUIRED.set_flag_extension(visa_metric, VisaRequiredExtensions.ELECTRON_VISA)

    if 'easy' in visa_data:
        VISA_REQUIRED.set_flag_extension(visa_metric, VisaRequiredExtensions.EASY_VISA)

    if 'visa_on_arrival' in visa_data:
        VISA_REQUIRED.set_flag_extension(visa_metric, VisaRequiredExtensions.VISA_ON_ARRIVAL)

    visa_free_stay = row.get('visa_free_stay', None)
    if visa_free_stay is not None:
        VISA_REQUIRED.add_no_visa_period(visa_metric, visa_free_stay)

    return {
        VISA_REQUIRED.name: visa_metric,
    }
