from typing import List

from travel.avia.country_restrictions.lib.table_format.base_format import BaseFormat
from travel.avia.country_restrictions.lib.table_format.metrics_as_columns_format import MetricsAsColumnsFormat
from travel.avia.country_restrictions.lib.parsers.to_yt_table_parser import ToYtTableParser
from travel.avia.country_restrictions.lib.types import InformationTable
from travel.avia.country_restrictions.lib.types.metric_type import ALL_METRICS
from travel.avia.country_restrictions.lib.types.metric_type.metric_type import MetricType
from travel.avia.country_restrictions.parsers.inline_admin.data import DATA


class InlineAdminParser(ToYtTableParser):
    SOURCE_ID = 'inline-admin'
    METRIC_TYPES: List[MetricType] = ALL_METRICS

    UPDATING_TABLE_NAME = 'source-inline-admin-result'
    OUTPUT_TABLE_FORMATS: List[BaseFormat] = [
        MetricsAsColumnsFormat(output_table_short_name='source-inline-admin-result')
    ]

    PARSER_NAME = SOURCE_ID

    def get_initial_data(self) -> InformationTable:
        return {}

    def get_data(self, old_data) -> InformationTable:
        return DATA
