import datetime

from travel.avia.country_restrictions.lib.types.metric_type import FORMS_TO_FILL, TOURISM_AVAILABILITY, \
    FLIGHTS_AVAILABILITY, QUARANTINE_REQUIRED, PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED, VISA_REQUIRED, \
    TOURISM_AVAILABLE_FROM_METRIC_TYPE, AIRPORT_AVAILABILITY_IN_COUNTRY


DATA = {
    'l225': {
        FORMS_TO_FILL.name: FORMS_TO_FILL.generate_metric(
            value=['https://www.gosuslugi.ru/600340/1/form?_=1645013851582'],
            updated_user='@nikhovas',
        ),
    },
    'r22418': {
        FLIGHTS_AVAILABILITY.name: FLIGHTS_AVAILABILITY.generate_metric(
            value=True,
            updated_user='@nikhovas',
        ),
        TOURISM_AVAILABILITY.name: TOURISM_AVAILABILITY.generate_metric(
            value=True,
            updated_user='@nikhovas',
        ),
        QUARANTINE_REQUIRED.name: QUARANTINE_REQUIRED.generate_metric(
            value=False,
            updated_user='@nikhovas',
        ),
        PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED.name: PCR_EXPIRATION_PERIOD_IN_HOURS_OR_REQUIRED.generate_metric(
            value=False,
            updated_user='@nikhovas',
        ),
        VISA_REQUIRED.name: VISA_REQUIRED.generate_metric(
            value=True,
            updated_user='@nikhovas',
        ),
        FORMS_TO_FILL.name: FORMS_TO_FILL.generate_metric(
            value=['https://madeirasafe.com'],
            updated_user='@nikhovas',
        ),
    },
    'l135': {
        TOURISM_AVAILABLE_FROM_METRIC_TYPE.name: TOURISM_AVAILABLE_FROM_METRIC_TYPE.generate_metric(
            value=datetime.date(year=2022, month=4, day=1),
            updated_user='@nikhovas',
        )
    },
    'l10088': {
        AIRPORT_AVAILABILITY_IN_COUNTRY.name: AIRPORT_AVAILABILITY_IN_COUNTRY.generate_metric(
            value=False,
            updated_user='@nikhovas',
        )
    },
    'l10067': {
        AIRPORT_AVAILABILITY_IN_COUNTRY.name: AIRPORT_AVAILABILITY_IN_COUNTRY.generate_metric(
            value=False,
            updated_user='@nikhovas',
        )
    },
    'l10070': {
        AIRPORT_AVAILABILITY_IN_COUNTRY.name: AIRPORT_AVAILABILITY_IN_COUNTRY.generate_metric(
            value=False,
            updated_user='@nikhovas',
        )
    },
    'l21359': {
        AIRPORT_AVAILABILITY_IN_COUNTRY.name: AIRPORT_AVAILABILITY_IN_COUNTRY.generate_metric(
            value=False,
            updated_user='@nikhovas',
        )
    },
    'l21618': {
        AIRPORT_AVAILABILITY_IN_COUNTRY.name: AIRPORT_AVAILABILITY_IN_COUNTRY.generate_metric(
            value=False,
            updated_user='@nikhovas',
        )
    },
    'l21619': {
        AIRPORT_AVAILABILITY_IN_COUNTRY.name: AIRPORT_AVAILABILITY_IN_COUNTRY.generate_metric(
            value=False,
            updated_user='@nikhovas',
        )
    },
    'c573088': {
        AIRPORT_AVAILABILITY_IN_COUNTRY.name: AIRPORT_AVAILABILITY_IN_COUNTRY.generate_metric(
            value=False,
            updated_user='@nikhovas',
        )
    }
}
