import argparse
import os
import re

from jinja2 import Template


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--source', required=True)
    parser.add_argument('--destination', required=True)
    parser.add_argument('--without-app', action='store_true')

    args = parser.parse_args()

    with open(args.source, 'r') as f:
        template = Template(f.read())

    deploy_stage_id = os.environ['DEPLOY_STAGE_ID']
    deploy_stage_id_parts = deploy_stage_id.split('-')

    matches = re.match('^{}-(.+)-{}$'.format(deploy_stage_id_parts[0], deploy_stage_id_parts[-1]), deploy_stage_id)
    application = matches.group(1)

    configs = ['sys-fs.conf']
    if not args.without_app:
        configs.append('app.conf')

    config = template.render(
        project=os.getenv('SOLOMON_PROJECT', deploy_stage_id_parts[0]),
        application=application,
        environment=deploy_stage_id_parts[-1],
        component=os.environ['DEPLOY_UNIT_ID'],
        instance=os.environ['DEPLOY_POD_PERSISTENT_FQDN'],
        host=os.environ['DEPLOY_POD_TRANSIENT_FQDN'],
        datacenter=os.environ['DEPLOY_NODE_DC'].upper(),
        configs=configs,
    )
    with open(args.destination, 'w') as f:
        f.write(config)


if __name__ == '__main__':
    main()
