#!/usr/bin/env python3
# encoding: utf-8

import argparse
import json
import os.path

import common


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--auth-token-path', default=os.path.expanduser('~/.solomon/token'))
    args = parser.parse_args()

    reader = common.SolomonAlerts(args.auth_token_path)
    alerts = reader.list_alerts()

    for alert in alerts:
        data = reader.get_alert(alert['id'])
        reader.drop_system_fields(data)
        path = os.path.join(common.ALERTS_DIR, '%s.json' % alert['id'])
        with open(path, 'wt') as f:
            json.dump(data, f, indent=2)
        print('Alert %s saved' % alert['id'])
    print('Done')







if __name__ == '__main__':
    main()
