# -*- encoding: utf-8 -*-
import logging

import click

from travel.avia.devops.zero_diff_releaser.lib.releaser import Releaser


@click.group('manual release')
def release():
    pass


@release.command('box')
@click.argument('stage')
@click.argument('deploy_unit')
@click.argument('box')
@click.option('--cause', 'cause', default="manual", show_default=True)
@click.option('--dctl', 'dctl')
@click.option('-v', '--verbose', 'verbose', is_flag=True)
def box_command(stage, deploy_unit, box, cause, dctl, verbose):
    setup_logging(verbose)

    releaser = Releaser(stage, deploy_unit, box=box, cause=cause, dctl=dctl)
    click.echo('Start releasing...')
    releaser.run()


@release.command('workload')
@click.argument('stage')
@click.argument('deploy_unit')
@click.argument('workload')
@click.option('--cause', 'cause', default="manual", show_default=True)
@click.option('--dctl', 'dctl')
@click.option('-v', '--verbose', 'verbose', is_flag=True)
def workload_command(stage, deploy_unit, workload, cause, dctl, verbose):
    setup_logging(verbose)

    releaser = Releaser(stage, deploy_unit, workload=workload, cause=cause, dctl=dctl)
    click.echo('Start releasing...')
    releaser.run()


def setup_logging(verbose):
    logger = logging.root
    logger.setLevel(logging.WARNING)
    if verbose:
        logger.setLevel(logging.INFO)
        logger.addHandler(logging.StreamHandler())


if __name__ == '__main__':
    release()
