import os
import sys
import logging

from travel.avia.docker.fetch_racktables.racktables import get_subnets


def allow_yandex_only(macros, destination):
    logging.info('Start fetch %s to %s', macros, destination)
    count = 0
    subnets = get_subnets(macros)
    with open(destination, 'w') as auth_file:
        for subnet in subnets:
            auth_file.write('allow {subnet};\n'.format(subnet=subnet))
            count += 1
        auth_file.write('allow 127.0.0.1;\n')
        auth_file.write('allow ::1;\n')
        auth_file.write('deny all;\n')

    logging.info('%d lines have been written', count)
    logging.info('End')


def deny_selenium(macros, destination):
    logging.info('Start fetch %s to %s', macros, destination)
    count = 0
    subnets = get_subnets(macros)
    with open(destination, 'w') as auth_file:
        for subnet in subnets:
            auth_file.write('deny {subnet};\n'.format(subnet=subnet))
            count += 1

    logging.info('%d lines have been written', count)
    logging.info('Done')


if __name__ == '__main__':
    logging.basicConfig(
        format='%(asctime)s %(levelname)s %(message)s',
        datefmt='%m/%d/%Y %H:%M:%S',
        stream=sys.stdout,
        level=logging.INFO,
    )

    if os.getenv('YANDEX_ENVIRONMENT_TYPE', '').startswith('sandbox_'):
        logging.info(
            'Fetching racktables is disabled for YANDEX_ENVIRONMENT_TYPE=%s',
            os.getenv('YANDEX_ENVIRONMENT_TYPE'),
        )
        exit()

    allow_yandex_only('_YANDEXNETS_', '/etc/nginx/auth/allow_yandex_only')
    deny_selenium('_SELENIUMGRIDNETS_', '/etc/nginx/auth/deny_selenium')

    logging.info('Restarting nginx')
    os.popen('supervisorctl signal HUP nginx')
