import logging
import re
import requests

RACKTABLE_URL = 'https://ro.racktables.yandex-team.ru/export/expand-fw-macro.php?macro={macros}'
RACKTABLE_TIMEOUT = 60
IP_RE = re.compile(r'^[0-9a-z\.\:\/]+$')


class RacktableError(Exception):
    pass


def get_subnets(macros):
    s = requests.Session()
    a = requests.adapters.HTTPAdapter(max_retries=5)
    s.mount('', a)
    response = s.get(RACKTABLE_URL.format(macros=macros), timeout=RACKTABLE_TIMEOUT)
    if response.status_code != 200:
        raise RacktableError(response.content)

    for line in response.text.split('\n'):
        line = line.strip()
        if line:
            if not IP_RE.match(line):
                logging.warning('Wrong ip: %s', line)
                continue
            yield line

    s.close()
