from subprocess import Popen, PIPE
import re

ALLOWED_MOUNT_POINTS = ['/', '/ephemeral']


class DiskSpace:
    def __init__(self, logger, registry):
        self._logger = logger

    def pull(self, ts, consumer):
        process = Popen(['df', '-k'], stdout=PIPE, stderr=PIPE)
        return_code = process.wait()
        df_result, stderr = process.stdout.read(), process.stderr.read()
        if return_code != 0:
            self._logger.error('df failed, stdout: %s, stderr: %s', df_result, stderr)
            return

        for row in df_result.split('\n')[1:-1]:
            values = re.sub(' +', ' ', row).split(' ')
            size_kb = int(values[1])
            used_kb = int(values[2])
            free_kb = int(values[3])
            mounted_on = values[5]
            if mounted_on in ALLOWED_MOUNT_POINTS:
                consumer.gauge({'sensor': 'disk-size', 'mount_point': mounted_on}, ts, size_kb)
                consumer.gauge({'sensor': 'disk-free', 'mount_point': mounted_on}, ts, free_kb)
                consumer.gauge({'sensor': 'disk-used', 'mount_point': mounted_on}, ts, used_kb)
