# coding=utf-8
from __future__ import print_function

import json
import os
import re

RE_PID = re.compile(r'^.+-(\d+)\.log.*$')

push_client_executable = '/usr/bin/push-client'

for push_client in os.popen('ps -eo command | grep ' + push_client_executable):
    push_client = push_client.rstrip('\n')
    if not push_client.startswith(push_client_executable) or not push_client.endswith('.yaml'):
        continue
    print('Processing: {}'.format(push_client))
    for f in json.load(os.popen(push_client + ' --status --json')):
        filename = f['actual name']
        matches = RE_PID.match(filename)
        if not matches:
            continue

        pid = int(matches.group(1))
        print('Check pid: {}'.format(pid))
        try:
            os.kill(pid, 0)
            continue
        except OSError:
            pass

        lag = f['lag']  # физический лаг в файтах = file_size - file_offset
        inflight_chunks = f['inflight chunks']  # Сколько сообщений отправили на сервер, но не получили подтверждение
        if lag > 0:
            print('lag={}, skip'.format(lag))
            continue
        if inflight_chunks > 0:
            print('inflight_chunks={}, skip'.format(inflight_chunks))
            continue

        print('Remove: {}'.format(filename + '*'))
        os.popen('rm ' + filename + '*')
