# -*- encoding: utf-8 -*-
import logging
from argparse import ArgumentParser

from pathlib2 import Path

from travel.avia.dump_data.lib import new_dumper


def main():
    logging.basicConfig(level=logging.DEBUG)

    parser = ArgumentParser()

    parser.add_argument('--host', help='Database host', required=True)
    parser.add_argument('--password', required=True)
    parser.add_argument('--user', default='avia')
    parser.add_argument('--db', default='avia')

    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)

    parser.add_argument('-o', '--output', default='./output', help='Directory path for output data')

    arguments = parser.parse_args()

    output_dir = Path(arguments.output)
    output_dir.mkdir(parents=True, exist_ok=True)
    logging.info('Created directory {}'.format(output_dir.absolute()))

    importer = new_dumper(
        host=arguments.host,
        password=arguments.password,
        user=arguments.user,
        database=arguments.db,

        yt_proxy=arguments.yt_proxy,
        yt_token=arguments.yt_token,

        output_dir=output_dir,
    )
    importer.dump_all()


if __name__ == '__main__':
    main()
