# -*- encoding: utf-8 -*-
import logging
from pathlib2 import Path  # noqa

from travel.avia.dump_data.lib.collector import Collector
from travel.avia.dump_data.lib.model_declaration import model_declaration
from travel.avia.dump_data.lib.mysql_connector import MysqlConnector, MysqlParameters
from yt.wrapper import YtClient


class Dumper(object):
    def __init__(self, collector, output_dir):
        # type: (Collector, Path) -> None
        self.collector = collector
        self.output_dir = output_dir

    def dump_all(self):
        logging.info('Start import data')

        for model in self.collector.iter_by_models():
            logging.info('Start import %s', model.name)
            model.dump_into_directory(self.output_dir)

        logging.info('Finish import')


def new_dumper(host, password, user, database, yt_proxy, yt_token, output_dir):
    # type: (...) -> Dumper
    return Dumper(
        Collector(
            model_declaration=model_declaration,
            mysql_connector=MysqlConnector(
                db_parameters=MysqlParameters(
                    host=host,
                    password=password,
                    user=user,
                    database=database,
                ),
            ),
            yt_client=YtClient(
                proxy=yt_proxy,
                token=yt_token,
            ),
        ),
        output_dir=output_dir
    )
