# -*- encoding: utf-8 -*-
import six
from abc import ABCMeta, abstractmethod
from pathlib2 import Path  # noqa


class BaseModel(six.with_metaclass(ABCMeta)):
    @property
    @abstractmethod
    def name(self):
        """Name of model"""

    @abstractmethod
    def dump_into_directory(self, directory):
        # type: (Path) -> None
        """Method for dumping data into file in `directory`"""

    def get_output_file_name(self):
        return '{}.bin'.format(self.name.lower())
