# -*- encoding: utf-8 -*-
from travel.avia.dump_data.lib import model_classes as mc
from travel.proto.avia.wizard.direction_national_pb2 import TDirectionNational
from travel.proto.avia.wizard.min_price_pb2 import TMinPrice
from travel.proto.avia.wizard.route_count_pb2 import TRouteCount
from travel.proto.avia.wizard.settlement_national_pb2 import TSettlementNational

from travel.proto.dicts.avia.avia_company_pb2 import TAviaCompany
from travel.proto.dicts.avia.near_direction_pb2 import TNearDirection
from travel.proto.dicts.avia.city_majority_pb2 import TCityMajority
from travel.proto.dicts.avia.code_system_pb2 import TCodeSystem
from travel.proto.dicts.avia.company_pb2 import TCompany
from travel.proto.dicts.avia.company_tariff_pb2 import TCompanyTariff
from travel.proto.dicts.avia.country_pb2 import TCountry
from travel.proto.dicts.avia.currency_pb2 import TCurrency
from travel.proto.dicts.avia.iata_correction_pb2 import TIataCorrection
from travel.proto.dicts.avia.point_synonym_pb2 import TPointSynonym
from travel.proto.dicts.avia.region_pb2 import TRegion
from travel.proto.dicts.avia.settlement_big_image_pb2 import TSettlementBigImage
from travel.proto.dicts.avia.settlements_pb2 import TSettlement
from travel.proto.dicts.avia.station2settlement_pb2 import TStation2Settlement
from travel.proto.dicts.avia.station_code_pb2 import TStationCode
from travel.proto.dicts.avia.station_pb2 import TStation
from travel.proto.dicts.avia.translated_title_pb2 import TTranslatedTitle
from travel.proto.dicts.avia.top_flight_pb2 import TTopFlight


model_declaration = dict(
    avia_company=dict(
        model=mc.MysqlModel,
        db_table='avia_aviacompany',
        proto_model=TAviaCompany,
        fields=[
            dict(proto_attribute='RaspCompanyId', db_column='rasp_company_id'),
            dict(proto_attribute='CostType', db_column='cost_type'),
            dict(proto_attribute='CarryonLength', db_column='carryon_length'),
            dict(proto_attribute='CarryonWidth', db_column='carryon_width'),
            dict(proto_attribute='CarryonHeight', db_column='carryon_height'),
            dict(proto_attribute='CarryonDimensionsSum', db_column='carryon_dimensions_sum'),
            dict(proto_attribute='BaggageLength', db_column='baggage_length'),
            dict(proto_attribute='BaggageWidth', db_column='baggage_width'),
            dict(proto_attribute='BaggageHeight', db_column='baggage_height'),
            dict(proto_attribute='BaggageDimensionsSum', db_column='baggage_dimensions_sum'),
        ],
    ),

    near_direction=dict(
        model=mc.MysqlModel,
        db_table='avia_neardirection',
        proto_model=TNearDirection,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='DepartureSettlementId', db_column='departure_settlement_id'),
            dict(proto_attribute='ArrivalSettlementId', db_column='arrival_settlement_id'),
            dict(proto_attribute='MinDistance', db_column='min_distance'),
            dict(proto_attribute='DefaultDistance', db_column='default_distance'),
            dict(proto_attribute='MaxDistance', db_column='max_distance'),
        ],
    ),

    top_flight=dict(
        model=mc.MysqlModel,
        db_table='tickets_topflight',
        proto_model=TTopFlight,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='FromPointKey', db_column='from_point_key'),
            dict(proto_attribute='ToPointKey', db_column='to_point_key'),
            dict(proto_attribute='DayOfWeek', db_column='day_of_week'),
            dict(proto_attribute='NationalVersion', db_column='national_version'),
            dict(proto_attribute='Redirects', db_column='redirects'),
            dict(proto_attribute='Flights', db_column='flights'),
        ],
    ),

    city_majority=dict(
        model=mc.MysqlModel,
        db_table='www_citymajority',
        proto_model=TCityMajority,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='Title', db_column='title'),
        ],
    ),

    code_system=dict(
        model=mc.MysqlModel,
        db_table='www_codesystem',
        proto_model=TCodeSystem,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='Code', db_column='code'),
        ],
    ),

    company=dict(
        model=mc.MysqlModel,
        db_table='www_company',
        proto_model=TCompany,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='Iata', db_column='iata'),
            dict(proto_attribute='SirenaID', db_column='sirena_id'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='TitleRu', db_column='title_ru'),
            dict(proto_attribute='TitleEn', db_column='title_en'),
            dict(proto_attribute='TitleUk', db_column='title_uk'),
            dict(proto_attribute='TitleTr', db_column='title_tr'),
            dict(proto_attribute='NewLTitleID', db_column='new_L_title_id'),
            dict(proto_attribute='Slug', db_column='slug'),
            dict(proto_attribute='AllianceID', db_column='alliance_id'),
            dict(proto_attribute='URL', db_column='url'),
            dict(proto_attribute='Logo', db_column='logo'),
            dict(proto_attribute='SvgLogo2', db_column='svg_logo2'),
            dict(proto_attribute='LogoBGColor', db_column='logo_bgcolor'),
        ],
    ),

    company_tariff=dict(
        model=mc.MysqlModel,
        db_table='avia_companytariff',
        proto_model=TCompanyTariff,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='AviaCompanyId', db_column='avia_company_id'),
            dict(proto_attribute='BaggageAllowed', db_column='baggage_allowed'),
            dict(proto_attribute='Carryon', db_column='carryon'),
            dict(proto_attribute='CarryonNorm', db_column='carryon_norm'),
            dict(proto_attribute='Published', db_column='published'),
        ],
    ),

    country=dict(
        model=mc.MysqlModel,
        db_table='www_country',
        proto_model=TCountry,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='GeoId', db_column='_geo_id'),
            dict(proto_attribute='NewLTitleID', db_column='new_L_title_id'),
        ],
    ),

    currency=dict(
        model=mc.MysqlModel,
        db_table='avia_currency',
        proto_model=TCurrency,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='Code', db_column='code'),
            dict(proto_attribute='IsoCode', db_column='iso_code'),
            dict(proto_attribute='Priority', db_column='priority'),
            dict(proto_attribute='Enable', db_column='enable'),
        ],
    ),

    direction_national=dict(
        model=mc.MysqlModel,
        db_table='avia_aviadirectionnational',
        proto_model=TDirectionNational,
        fields=[
            dict(proto_attribute='DepartureSettlementID', db_column='departure_settlement_id'),
            dict(proto_attribute='ArrivalSettlementID', db_column='arrival_settlement_id'),
            dict(proto_attribute='Popularity', db_column='popularity'),
            dict(proto_attribute='NationalVersion', db_column='national_version'),
            dict(proto_attribute='ID', db_column='id'),
        ],
    ),

    iata_correction=dict(
        model=mc.MysqlModel,
        db_table='importinfo_iatacorrection',
        proto_model=TIataCorrection,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='Code', db_column='code'),
            dict(proto_attribute='Number', db_column='number'),
            dict(proto_attribute='CompanyId', db_column='company_id'),
        ],
    ),

    min_price=dict(
        model=mc.MinPriceModel,
        proto_model=TMinPrice,
    ),

    point_synonym=dict(
        model=mc.MysqlModel,
        db_table='www_pointsynonym',
        proto_model=TPointSynonym,
        fields=[
            dict(proto_attribute='ID', db_column='id'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='ContentTypeID', db_column='content_type_id'),
            dict(proto_attribute='ObjectID', db_column='object_id'),
            dict(proto_attribute='SearchType', db_column='search_type'),
        ],
    ),

    region=dict(
        model=mc.MysqlModel,
        db_table='www_region',
        proto_model=TRegion,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='GeoId', db_column='_geo_id'),
            dict(proto_attribute='NewLTitleID', db_column='new_L_title_id'),
            dict(proto_attribute='TimeZone', db_column='time_zone'),
        ],
    ),

    route_count=dict(
        model=mc.RouteCountModel,
        proto_model=TRouteCount,
    ),

    settlement_big_image=dict(
        model=mc.MysqlModel,
        db_table='avia_settlementbigimage',
        proto_model=TSettlementBigImage,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='SettlementId', db_column='settlement_id'),
            dict(proto_attribute='Url2', db_column='url2'),
        ],
    ),

    settlement_national=dict(
        model=mc.MysqlModel,
        db_table='avia_aviasettlementnational',
        proto_model=TSettlementNational,
        fields=[
            dict(proto_attribute='SettlementID', db_column='settlement_id'),
            dict(proto_attribute='Popularity', db_column='popularity'),
            dict(proto_attribute='NationalVersion', db_column='national_version'),
            dict(proto_attribute='Arrival', db_column='arrival'),
        ],
    ),

    settlements=dict(
        model=mc.MysqlModel,
        db_table='www_settlement',
        proto_model=TSettlement,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='GeoId', db_column='_geo_id'),
            dict(proto_attribute='CountryId', db_column='country_id'),
            dict(proto_attribute='RegionId', db_column='region_id'),
            dict(proto_attribute='IataCode', db_column='iata'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='Longitude', db_column='longitude'),
            dict(proto_attribute='Latitude', db_column='latitude'),
            dict(proto_attribute='MajorityID', db_column='majority_id'),
            dict(proto_attribute='NewLTitleID', db_column='new_L_title_id'),
            dict(proto_attribute='Hidden', db_column='hidden'),
            dict(proto_attribute='TimeZone', db_column='time_zone'),
            dict(proto_attribute='SirenaID', db_column='sirena_id'),
            dict(proto_attribute='TitleRuPrepositionVVoNa', db_column='title_ru_preposition_v_vo_na'),
            dict(proto_attribute='TypeChoices', db_column='type_choices'),
        ],
    ),

    station=dict(
        model=mc.MysqlModel,
        db_table='www_station',
        proto_model=TStation,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='MajorityId', db_column='majority_id'),
            dict(proto_attribute='SettlementId', db_column='settlement_id'),
            dict(proto_attribute='TTypeId', db_column='t_type_id'),
            dict(proto_attribute='Hidden', db_column='hidden'),
            dict(proto_attribute='RegionId', db_column='region_id'),
            dict(proto_attribute='CountryId', db_column='country_id'),
            dict(proto_attribute='TimeZone', db_column='time_zone'),
            dict(proto_attribute='Title', db_column='title'),
            dict(proto_attribute='NewLTitleID', db_column='new_L_title_id'),
            dict(proto_attribute='StationTypeID', db_column='station_type_id'),
            dict(proto_attribute='TitleRuPrepositionVVoNa', db_column='title_ru_preposition_v_vo_na'),
        ],
    ),

    station_to_settlement=dict(
        model=mc.MysqlModel,
        db_table='www_station2settlement',
        proto_model=TStation2Settlement,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='StationId', db_column='station_id'),
            dict(proto_attribute='SettlementId', db_column='settlement_id'),
        ],
    ),

    station_code=dict(
        model=mc.MysqlModel,
        db_table='www_stationcode',
        proto_model=TStationCode,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='StationId', db_column='station_id'),
            dict(proto_attribute='SystemId', db_column='system_id'),
            dict(proto_attribute='Code', db_column='code'),
        ],
    ),

    translated_title=dict(
        model=mc.MysqlModel,
        db_table='www_translated_title',
        proto_model=TTranslatedTitle,
        fields=[
            dict(proto_attribute='Id', db_column='id'),
            dict(proto_attribute='RuNominative', db_column='ru_nominative'),
            dict(proto_attribute='RuGenitive', db_column='ru_genitive'),
            dict(proto_attribute='RuDative', db_column='ru_dative'),
            dict(proto_attribute='RuAccusative', db_column='ru_accusative'),
            dict(proto_attribute='RuLocative', db_column='ru_locative'),
            dict(proto_attribute='EnNominative', db_column='en_nominative'),
            dict(proto_attribute='TrNominative', db_column='tr_nominative'),
            dict(proto_attribute='UkNominative', db_column='uk_nominative'),
            dict(proto_attribute='UkAccusative', db_column='uk_accusative'),
            dict(proto_attribute='DeNominative', db_column='de_nominative'),
        ],
    ),
)
