# -*- encoding: utf-8 -*-

from collections import namedtuple

import MySQLdb
from MySQLdb.cursors import DictCursor


class MysqlParameters(namedtuple('MysqlParameters', [
    'host',
    'password',
    'user',
    'database',
])):
    pass


class MysqlConnector(object):
    CONNECTION_PARAMS = {
        'charset': 'utf8',
        'use_unicode': False,
        'local_infile': True,
    }

    def __init__(self, db_parameters):
        # type: (MysqlParameters) -> None
        self.db_parameters = db_parameters

    def get_connection(self):
        return MySQLdb.connect(
            host=self.db_parameters.host,
            user=self.db_parameters.user,
            passwd=self.db_parameters.password,
            db=self.db_parameters.database,
            cursorclass=DictCursor,
            **self.CONNECTION_PARAMS
        )
