package api

import (
	"a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/dicts"
	"a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/storage"
	"a.yandex-team.ru/travel/avia/library/go/probes"
	dynamicdicts "a.yandex-team.ru/travel/library/go/dicts/updaterservice"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
)

type Config struct {
	EnvType      string `config:"YENV_TYPE,required" yaml:"yenv_type"`
	Logging      logging.Config
	HTTP         httpserver.HTTPConfig
	Storage      storage.StorageConfig
	Dicts        dicts.Config        `yaml:"dicts"`
	DictsUpdater dynamicdicts.Config `yaml:"dicts_updater"`
	Probes       probes.HTTPConfig   `yaml:"probes"`
}

var defaultHTTPConfig = httpserver.HTTPConfig{
	Addr:           httpserver.DefaultHTTPConfig.Addr,
	LogAllRequests: httpserver.DefaultHTTPConfig.LogAllRequests,
}

var Cfg = Config{
	EnvType:      "development",
	Logging:      logging.DefaultConfig,
	HTTP:         defaultHTTPConfig,
	Storage:      storage.DefaultConfig,
	Dicts:        dicts.DefaultConfig,
	DictsUpdater: dynamicdicts.DefaultConfig,
	Probes:       probes.DefaultHTTPConfig,
}
