package payloads

import (
	farefamiliesstructs "a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/data_structs/fare_families"
)

// Почти повторяет описание структуры Variants из шины данных:
// https://a.yandex-team.ru/arc/trunk/arcadia/travel/avia/search_results_queue_producer/internal/searchresultscache/types.go
// TODO(u-jeen): объединить структуры, вынести в общую библиотеку
type VariantsFromPartner struct {
	AllVariantsCount int32                     `json:"all_variants_count"`
	Created          int64                     `json:"created"`
	Expire           int64                     `json:"expire"`
	Fares            map[string]VariantsFare   `json:"fares"`
	Flights          map[string]VariantsFlight `json:"flights"`
	QueryID          string                    `json:"qid"`
	QueryTime        float64                   `json:"query_time"`
}

type VariantsFare struct {
	Baggage         [][]string      `json:"baggage"`
	Charter         bool            `json:"charter"`
	Created         int64           `json:"created"`
	Expire          int64           `json:"expire"`
	FareCodes       [][]string      `json:"fare_codes"`
	PriceCategory   string          `json:"price_category"`
	Route           [][]string      `json:"route"`
	Selfconnect     bool            `json:"selfconnect"`
	Tariff          TariffValue     `json:"tariff"`
	YandexPlusPromo YandexPlusPromo `json:"yandex_plus_promo"`
}

type TariffValue struct {
	Currency string  `json:"currency"`
	Value    float32 `json:"value"`
}

type YandexPlusPromo struct {
	PlusPoints []map[string]int32 `json:"PlusPoints"`
	Total      int32              `json:"total"`
}

type VariantsFlight struct {
	Arrival       FlightTime           `json:"arrival"`
	AviaCompany   int32                `json:"aviaCompany"`
	Company       int32                `json:"company"`
	CompanyTariff int64                `json:"companyTariff"`
	Departure     FlightTime           `json:"departure"`
	From          int64                `json:"from"`
	Key           string               `json:"key"`
	Number        string               `json:"number"`
	Operating     OperatingFlightTitle `json:"operating"`
	To            int64                `json:"to"`
}

type FlightTime struct {
	LocalTime string `json:"local"`
	Offset    int32  `json:"offset"`
	TZName    string `json:"tzname"`
}

type OperatingFlightTitle struct {
	Company int32  `json:"company"`
	Title   string `json:"number"`
}

type FareFamiliesEntry struct {
	FareFamilyKeys   [][]string `json:"fare_families"`
	FareFamiliesHash string     `json:"fare_families_hash"`
}

type FareFamiliesMap struct {
	FareFamiliesReference map[string]farefamiliesstructs.FareFamilyForVariant `json:"fareFamilies"`
	VariantsMap           map[string]FareFamiliesEntry                        `json:"variantsMap"`
}
